local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end


// window init.
function PANEL:Init( )
	// drag info
	self.DragInfo	= {
		Dragging = false,
		StartPos = { 0, 0 },
	};
	
	// resize info
	self.ResizeInfo	= {
		Resizing = false,
		StartPos = { 0, 0 },
		StartSize = { 0, 0 },
	}
	
	
	// AppFramework - LinkToClass
	self.LinkedClass = nil;
	
	// window information
	self.Sizeable = true;
	self.Closeable = true;
	self.Moveable = true;
	self.DrawWindow = true;
	self.HasCaption = true;
	
	// create a close button.
	self.CloseButton = CtlImageButton_class:create( self );
	self.CloseButton:SetMaterial( AppFramework:Theme().icons['close_button'] );
	self.CloseButton:AddEvent( "OnClick", "ClosePressed", self );
	
	// windows have a caption, so lets create a label.
	self.Caption = vgui.Create( "Label", self );
	
	// icon.
	self.Icon = nil;
	
	// create resizer icon
	self.Resizer = vgui.Create( "ctl_icon", self );
	self.Resizer:SetMaterial( AppFramework:Theme().icons['resizer'] );
	
	// make textentry controls work on me.
	self:DoModal();
	
	// invalidate
//	self:InvalidateLayout();
	
end

// set icon
function PANEL:SetIcon( mat )
	// create
	self.Icon = vgui.Create( "ctl_icon", self );
	self.Icon:SetMaterial( mat );

end


// apply scheme settings
function PANEL:ApplySchemeSettings( )
	// set font and color of the caption.
	self.Caption:SetFont( AppFramework:Theme().fonts['title'] );
	self.Caption:SetFGColor( AppFramework:Theme().colors['title'] );
	
end


// we pressed close
function PANEL:ClosePressed( )
	// application controls closure.
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnClose" );
		
	end
	
end



// perform layout.
function PANEL:PerformLayout( )
	// calculate text height of the font.
	surface.SetFont( AppFramework:Theme().fonts['title'] );
	local w, h = surface.GetTextSize( "A" );
	
	// text pos.
	local ofsx = 8;
	local ofsy = 16 - h * 0.5;
	
	// do we have an icon?
	if( self.Icon ) then
		// icon shifts text over.
		ofsx = 32;
		
		// place icon.
		self.Icon:SetSize( 16, 16 );
		self.Icon:SetPos( 8, 8 );
		
	end
	
	// hide sizeable if we're not sizeable.
	if( !self.Sizeable && self.Resizer:IsVisible() ) then
		self.Resizer:SetVisible( false );
		
	// place close.
	elseif( self.Sizeable ) then
		// show if not visible
		if( !self.Resizer:IsVisible() ) then self.Resizer:SetVisible( true ); end
		
		// position.
		self.Resizer:SetSize( 32, 32 );
		self.Resizer:SetPos(
			self:GetWide() - 18,
			self:GetTall() - 18
		);

	end
	
	// hide close if we're not closeable.
	if( !self.Closeable && self.CloseButton:IsVisible() ) then
		self.CloseButton:Hide();
		
	// place close.
	elseif( self.Closeable ) then
		// show if not visible
		if( !self.CloseButton:IsVisible() ) then self.CloseButton:Hide(); end
		
		// position.
		self.CloseButton:SetSize( 16, 16 );
		self.CloseButton:SetPos( self:GetWide() - 24, 8 );

	end
	
	// caption?
	if( self.HasCaption ) then
		// show
		if( !self.Caption:IsVisible() ) then
			self.Caption:SetVisible( true );
			
		end
		
		// move the label.
		self.Caption:SizeToContents();
		self.Caption:SetPos( ofsx, ofsy );
		
	// hide caption.
	elseif( self.Caption:IsVisible() ) then
		// hide
		self.Caption:SetVisible( false );
		
	end
	
end



// think.
function PANEL:Think( )
	// get mouse pos
	local x, y = gui.MousePos();
	
	// application think.
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnThink" );
		
	end
	
	// outside of the screen bounds? stop dragging.
	if( x > ScrW() || x < 0 || y > ScrH() || y < 0 ) then
		// stop resizing or moving whatever.
		self.DragInfo.Dragging = false;
		self.ResizeInfo.Resizing = false;
		
		// release capture.
		self:MouseCapture( false );
		
		//
		return;
		
	end
	
	
	// resizing
	if( self.ResizeInfo.Resizing ) then
		// figure out how much the mouse has moved.
		local dx = x - self.ResizeInfo.StartPos[1];
		local dy = y - self.ResizeInfo.StartPos[2];
		
		// calc new size.
		local nw = math.Clamp( self.ResizeInfo.StartSize[1] + dx, 128, ScrW() );
		local nh = math.Clamp( self.ResizeInfo.StartSize[2] + dy, 128, ScrH() );
		
		// get current size.
		local w, h = self:GetSize();
		
		// check for changes.
		if( w != nw || h != nh ) then
			// size
			self:SetSize( nw, nh );
			
			// invalidate
			self:InvalidateLayout();
			
			// run events
			if( self.LinkedClass ) then
				self.LinkedClass:CallEvent( "OnResize", w, h, nw, nh );
				
			end
			
		end
		
	end


	// dragging
	if( self.DragInfo.Dragging ) then
		// did our position change?
		local wx, wy = self:GetPos();
		local x = x - self.DragInfo.StartPos[1];
		local y = y - self.DragInfo.StartPos[2];
		
		// any change?
		if( x != wx || y != wy ) then
			// move window
			self:SetPos( x, y );
			
			// events
			if( self.LinkedClass ) then
				self.LinkedClass:CallEvent( "OnMove", wx, wy, x, y );
				
			end
			
		end
		
	end
	
end



// cursor moved
function PANEL:OnCursorMoved( px, py )
	// run events.
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnMouseMoved", px, py );
		
	end
	
end




// window drag start.
function PANEL:OnMousePressed( mc )
	// fetch mouse coords.
	local x, y = gui.MousePos();
	local wx, wy = self:GetPos();
	local lx, ly = self:ScreenToLocal( x, y );
	
	// run events.
	if( self.LinkedClass ) then
		// two events? wow.
		self.LinkedClass:CallEvent( "OnClick", mc, lx, ly );
		self.LinkedClass:CallEvent( "OnMouseDown", mc, lx, ly );
		
	end
	
	// we inside the titlebar?
	if( ly <= 32 && self.Moveable ) then
		// drag
		self.DragInfo.Dragging = true;
		self.DragInfo.StartPos = { x - wx, y - wy };
		
		// capture!
		self:MouseCapture( true );
		
	elseif( ly > self:GetTall() - 32 && lx > self:GetWide() - 32 && self.Sizeable ) then
		// resize
		self.ResizeInfo.Resizing = true;
		self.ResizeInfo.StartPos = { x, y };
		self.ResizeInfo.StartSize = { self:GetWide(), self:GetTall() };
		
		// capture!
		self:MouseCapture( true );
		
	end

end

// released.
function PANEL:OnMouseReleased( mc )
	// disable drag.
	self.DragInfo.Dragging = false;
	self.ResizeInfo.Resizing = false;
	
	// release
	self:MouseCapture( false );
	
	// run events.
	if( self.LinkedClass ) then
		// call mouse released event.
		local x, y = gui.MousePos();
		local lx, ly = self:ScreenToLocal( x, y );
		self.LinkedClass:CallEvent( "OnMouseUp", mc, lx, ly );
		
	end
	
end




// paint.
function PANEL:Paint( )
	// draw the window if they have it set to draw.
	if( self.DrawWindow ) then
		AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_WINDOW );
		
	end
	
	//
	return true;
	
end

// register.
vgui.Register( "app_window", PANEL, "EditablePanel" );
